/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSParamParent;
import filenet.ws.api.WSTemplateBase;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSParamLeaf
extends WSParam {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSParamLeaf";
    private String[] m_enumValues = null;
    private String m_value = null;
    private boolean m_bAttribute = false;
    private boolean m_blankType = false;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 18:53:58  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.13  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                if (this.m_enumValues != null) {
                    String[] enumValues = this.m_enumValues;
                    this.m_enumValues = null;
                    for (int i = 0; i < enumValues.length; ++i) {
                        enumValues[i] = null;
                    }
                    enumValues = null;
                }
                this.m_value = null;
                super.releaseReferences();
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSParamLeaf() {
    }

    public WSParamLeaf(WSParamParent parent, String name, String namespace, String typeNSPrefix, String typeName) {
        super(parent, name, namespace, typeNSPrefix, typeName);
        this.m_bBaseType = true;
    }

    protected Vector getFlatParamList() {
        Vector<WSParamLeaf> v = new Vector<WSParamLeaf>();
        v.add(this);
        return v;
    }

    public String[] getEnumValues() {
        return this.m_enumValues;
    }

    public boolean isEnumType() {
        return this.m_enumValues != null && this.m_enumValues.length != 0;
    }

    public boolean isAttribute() {
        return this.m_bAttribute;
    }

    public void setIsAttribute(boolean bAttribute) {
        this.m_bAttribute = bAttribute;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public String getValue() {
        return this.m_value;
    }

    public String getTagName() {
        return this.getName();
    }

    public String toString() {
        String s = new String("******** leaf *******\n");
        s = s + super.toString();
        s = this.m_value != null ? s + "Value= " + this.m_value + "\n" : s + "Value= null\n";
        if (this.isEnumType()) {
            s = s + "Enum values: \n";
            if (this.m_enumValues != null && this.m_enumValues.length > 0) {
                for (int i = 0; i < this.m_enumValues.length; ++i) {
                    s = s + this.m_enumValues[i] + "\n";
                }
            }
        }
        s = s + "******** end of " + this.getName() + "\n\n";
        return s;
    }

    public String toXML() {
        String s = new String();
        s = s + "<" + this.getName();
        s = this.m_parent != null && this.m_parent.isSameNamespace(this.m_namespace) ? s + ">\n" : s + " xmlns='" + this.getNamespace() + "'>\n";
        s = s + this.m_value + "\n";
        s = s + "</" + this.getName() + ">\n";
        return s;
    }

    public String toXMLTemplate() {
        String s = new String();
        s = s + "<" + this.getName();
        s = this.m_parent != null && this.m_parent.isSameNamespace(this.m_namespace) ? s + ">\n" : s + " xmlns='" + this.getNamespace() + "'>\n";
        if (this.isEnumType()) {
            if (this.m_enumValues != null && this.m_enumValues.length > 0) {
                for (int i = 0; i < this.m_enumValues.length; ++i) {
                    if (i > 0) {
                        s = s + " or ";
                    }
                    s = s + this.m_enumValues[i] + "\n";
                }
            }
        } else {
            s = s + this.getTypeName() + "\n";
        }
        s = s + "</" + this.getName() + ">\n";
        return s;
    }

    protected void setEnumValues(String[] values) {
        this.m_enumValues = values;
    }

    protected void setBlankType(boolean bBlankType) {
        this.m_blankType = bBlankType;
    }

    protected boolean isBlankType() {
        return this.m_blankType;
    }

    protected void copyTo(WSParamLeaf to) {
        super.copyTo(to);
        if (this.m_enumValues != null) {
            to.setEnumValues(this.m_enumValues);
        }
        if (this.m_value != null) {
            to.setValue(new String(this.m_value));
        }
        to.setIsAttribute(this.m_bAttribute);
        to.setBlankType(this.m_blankType);
    }

    protected WSParam clone(WSParamParent parent) {
        WSParamLeaf clone = new WSParamLeaf();
        this.copyTo(clone);
        return clone;
    }

    protected Element createElement(Document doc, int bindingStyle) {
        Element element = super.createElement(doc, bindingStyle);
        if (this.m_value != null) {
            element.appendChild(doc.createTextNode(this.m_value));
        }
        return element;
    }

    protected Element createTemplateElement(Document doc, int bindingStyle) {
        Element element = super.createTemplateElement(doc, bindingStyle);
        String s = new String();
        if (this.isEnumType()) {
            if (this.m_enumValues != null && this.m_enumValues.length > 0) {
                for (int i = 0; i < this.m_enumValues.length; ++i) {
                    if (i > 0) {
                        s = s + " or ";
                    }
                    s = s + this.m_enumValues[i];
                }
            }
        } else {
            s = !this.isBlankType() ? s + this.getTypeName() : null;
        }
        if (s != null) {
            element.appendChild(doc.createTextNode(s));
        }
        return element;
    }

    protected void addTemplateElement(Document doc, Element pElement, int bindingStyle) {
        String s = new String();
        if (this.isEnumType()) {
            if (this.m_enumValues != null && this.m_enumValues.length > 0) {
                for (int i = 0; i < this.m_enumValues.length; ++i) {
                    if (i > 0) {
                        s = s + " or ";
                    }
                    s = s + this.m_enumValues[i];
                }
            }
        } else {
            s = !this.isBlankType() ? s + this.getTypeName() : null;
        }
        if (s != null) {
            s = WSTemplateBase.encodeTypeName(s);
        }
        if (this.m_bAttribute) {
            if (pElement != null) {
                String prefix = new String("");
                Attr attributeNode = null;
                String value = null;
                if (this.m_namespace != null && this.m_namespace.trim().length() > 0 && !this.m_parent.isSameNamespace(this.m_namespace)) {
                    prefix = "s";
                    for (int i = 0; i < 100; ++i) {
                        attributeNode = pElement.getAttributeNode("xmlns:" + prefix + i);
                        if (attributeNode == null) {
                            prefix = prefix + i;
                            pElement.setAttribute("xmlns:" + prefix, this.m_namespace);
                            break;
                        }
                        value = attributeNode.getValue();
                        if (value == null || value.compareTo(this.m_namespace) != 0) continue;
                        prefix = prefix + i;
                        break;
                    }
                    prefix = prefix + ":";
                }
                if (s != null) {
                    pElement.setAttribute(prefix + this.m_name, s);
                }
            }
        } else {
            Element element = super.createElement(doc, bindingStyle);
            if (bindingStyle == 2) {
                String value = null;
                value = this.m_typeNSPrefix != null ? this.m_typeNSPrefix + ":" + this.m_typeName : this.m_typeName;
                String aValue = pElement.getAttribute("xsi:type");
                if (aValue != null && aValue.length() > 0 && aValue.compareTo(value) != 0) {
                    element.setAttribute("xsi:type", value);
                }
            }
            if (s != null) {
                element.appendChild(doc.createTextNode(s));
            }
            if (pElement != null) {
                pElement.appendChild(element);
            }
        }
    }

    protected void populate(Node node) {
        Node child;
        if (node != null && VWStringUtils.compare(this.m_name, node.getNodeName()) == 0 && (child = node.getFirstChild()) != null && child.getNodeType() == 3) {
            this.m_value = child.getNodeValue();
        }
    }

    protected void reset() {
        this.m_value = null;
    }

    protected void removeAll() {
        this.m_value = null;
        if (this.m_enumValues != null) {
            for (int i = 0; i < this.m_enumValues.length; ++i) {
                this.m_enumValues[i] = null;
            }
            this.m_enumValues = null;
        }
    }
}

